
#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Interaction / Scenes"
	SimpleWait ( )
#ENDIF

Declare Sub Scene_To_Disp ( Page As Story_Page_Type, Scene As FB.Image Ptr )

Declare Sub Render_Scene ( Page As Story_Page_Type )

Declare Sub Scene_Entity_Scale ( ByRef Entity As Story_Entity_Type )

Declare Sub Scene_Render_Entity ( Entity ( Any ) As Story_Entity_Type, ByRef Dest As FB.Image Ptr )

Declare Sub Multi_Pg_Destroy ( Page ( Any ) As Story_Page_Type )

Declare Sub Pg_Destroy ( Page As Story_Page_Type )

Sub Multi_Pg_Destroy ( Page ( Any ) As Story_Page_Type )

	Dim As Long Location_Index = 0, Pg_Index = 0

	If UBound( Page, 1 ) < 0 Then
		Erase Page
		ReDim Page ( -1 To -1 )
		Exit Sub
	End If
		
	For Location_Index = UBound ( Page, 1 ) To LBound ( Page, 1 ) Step -1
	
		Pg_Destroy ( Page ( Location_Index ) )
					
	Next Location_Index

	Erase Page
	ReDim Page ( -1 To -1 )
	
End Sub

Sub Pg_Destroy ( Page As Story_Page_Type )

	Dim As Long Pg_Index = 0
		
	With Page
	
		For Pg_Index = 0 To Ubound ( .Layers, 1 ) Step 1

			If .Layers ( Pg_Index ) <> 0 Then
		
				ImageDestroy2 ( .Layers ( Pg_Index ) )
		
			End If
					
		Next Pg_Index
	
		Erase .Layers
		ReDim .Layers ( -1 To -1 )
	
	End With
		
End Sub

Sub Scene_To_Disp ( Page As Story_Page_Type, Scene As FB.Image Ptr )

	With Page	
	
		If .Layers ( Pg_Scene ) <> 0 Then
		
			ImageDestroy2 ( .Layers ( Pg_Scene ) )
		
		End If
	
		.Layers ( Pg_Scene ) = ImageCreate ( 320, 240, RGBA ( 0, 0, 0, 0 ), 32 )
	
		Put .Layers ( Pg_Scene ), ( ( .Layers ( Pg_Scene ) -> Width - Scene -> Width ) \ 2, ( .Layers ( Pg_Scene ) -> Height - Scene -> Height ) \ 2 ), Scene, Alpha
	
	End With
	
End Sub

Sub Render_Scene ( Page As Story_Page_Type )

	Dim As FB.Image Ptr Backdrop

	With Page

		Dim As String Backdrop_Image = _constIncPath_ & Gamepack.Root & Gamepack.Pack & "\Assets\Sprites\interface\" & "background" & ".png"

		If Backdrop <> 0 Then
	
			Backdrop = ImageDestroy2 ( Backdrop )
		
		End If
	
		If Is_File ( Backdrop_Image ) Then

			Backdrop = LoadRGBAFile ( Backdrop_Image )

		Else

			Backdrop = ImageCreate ( 64, 64, RGBA ( 0, 0, 0, 0 ), 32 )
	
		End If

		Dim As FB.Image Ptr Source
	
		Dim As String Source_Image = _constIncPath_ & Gamepack.Root & Gamepack.Pack & "\Assets\Sprites\scene\" & .Sprite & ".png"

		If Source <> 0 Then
	
			Source = ImageDestroy2 ( Source )
		
		End If

		If Is_File ( Source_Image ) Then

			Source = LoadRGBAFile ( Source_Image )

		Else
	
			Source = ImageCreate ( 64, 64, RGBA ( 0, 0, 0, 0 ), 32 )

		End If

		Gfx_Buffer_Repeat ( Backdrop, .Layers ( Pg_Background ) )

		Gfx_Buffer_Stretch_Aspect ( Source, .Layers ( Pg_Illustration ) )

		If .Scene <> 0 Then
			.Scene = ImageDestroy2 ( .Scene )
	
		End If
		
		.Scene = ImageCreate ( .Layers ( Pg_Illustration ) -> Width * 2, .Layers ( Pg_Illustration ) -> Height * 2, RGBA( 0, 0, 0, 0 ), 32 )
	
		Scene_Render_Entity ( .Entity ( ), .Scene )
	
		Backdrop = ImageDestroy2 ( Backdrop )

		Source = ImageDestroy2 ( Source )
	
		Scene_To_Disp ( Page, .Scene )

	End With

	Exit Sub

End Sub

Sub Scene_Entity_Scale ( ByRef Entity As Story_Entity_Type )
	
	With Entity
		Gfx_Buffer_Stretch ( .Sprite, .Scaled )
	End With
	
End Sub

Sub Scene_Render_Entity ( Entity ( Any ) As Story_Entity_Type, ByRef Dest As FB.Image Ptr )

	Dim As Long Entity_Index = 0, X = 0, Y = 0

	Dim As Long x0 = 0, y0 = 0, cX = 0, cY = 0, x2 = 0, y2 = 0, xA = 0
	Dim As FB.Image Ptr TempBackdrop
		
	Dim As Long sX = 24, sY = 24, xV = 0
		
	cX = ( Dest -> Width ) \ 2
	cY = ( Dest -> Height ) \ 2
	
	Dim As Long NPC_Count = -1, Item_Count = -1
	Dim As Long NPC_Index = -1, Item_Index = -1
			
	Dim As Long EntryX = 0, EntryY = 0
	Dim As Long EntryX2 = 0, EntryY2 = 0

	For Entity_Index = 0 To UBound ( Entity, 1 ) Step 1
		With Entity( Entity_Index )
		Select Case LCase ( .Element )
			Case "npc"
				NPC_Count += 1
			case "item"
				Item_Count += 1
			End Select
		End With
	Next Entity_Index
	
	For Entity_Index = 0 To UBound( Entity, 1 ) Step 1
		
		Entity_Sprite_Mode ( Entity ( Entity_Index ) )
		
		With Entity ( Entity_Index )
		
			Select Case LCase ( .Element )
		
			Case "npc"
			
				NPC_Count += 1

			Case "item"
						
				Item_Count += 1

			End Select
		
		End With
		
	Next Entity_Index

	NPC_Index = -1
	
	For Entity_Index = LBound( Entity, 1 ) To UBound( Entity, 1 ) Step 1
		
		With Entity ( Entity_Index )
						
			Select Case LCase ( .Element )
		
			Case "npc"
			
				NPC_Index += 1

				xA = 32
				xV = ( cX * 2 \ xA )

				sX = xA
				sY = xA

				EntryX = NPC_Index Mod xV
				EntryY = NPC_Index \ xV

				EntryX2 = NPC_Count Mod xV
				EntryY2 = NPC_Count \ xV
								
				x0 = ( EntryX * xA )
				y0 = ( EntryY * xA )

				If .Sprite <> 0 Then
		
					If .Scaled <> 0 Then
						ImageDestroy2 ( .Scaled )
					End If
			
					.Scaled = ImageCreate ( sX, sY, RGBA ( 0, 0, 0, 0 ), 32 )
				
					Scene_Entity_Scale ( Entity (Entity_Index ) )

					If .Scaled <> 0 Then
				
						x2 = x0 '- Entity ( Entity_Index ) .Scaled -> Width / 2
						y2 = cY - y0 - xA * 2 '- Entity ( Entity_Index ) .Scaled -> Height / 2

						Put Dest, ( x2, y2 ), .Scaled, Alpha
			
						ImageDestroy2 ( .Scaled )
			
					End If
			
					ImageDestroy2 ( .Sprite )
			
				End If
					
			End Select
			
		End With
		
	Next Entity_Index

	Item_Index = -1
	
	For Entity_Index = LBound( Entity, 1 ) To UBound( Entity, 1 ) Step 1
		
		With Entity ( Entity_Index )
		
			Select Case LCase ( .Element )
		
			Case "item"
			
				Item_Index += 1

				xA = 16
				xV = ( cX * 2 \ xA )

				sX = xA
				sY = xA
			
				EntryX = Item_Index Mod xV
				EntryY = Item_Index \ xV

				EntryX2 = Item_Count Mod xV
				EntryY2 = Item_Count \ xV
					
				x0 = ( EntryX * xA )
				y0 = ( EntryY * xA )

				If .Sprite <> 0 Then
		
					If .Scaled <> 0 Then
						ImageDestroy2 ( .Scaled )
					End If
			
					If TempBackdrop <> 0 Then
						TempBackdrop = ImageDestroy2 ( TempBackdrop )
					End If

					TempBackdrop = ImageCreate ( sX, sY, RGBA ( 0, 0, 0, 0 ), 32 )
					Gfx_Buffer_Fill ( TempBackdrop,,,,,,, "Fill" )

					.Scaled = ImageCreate ( sX, sY, RGBA ( 0, 0, 0, 0 ), 32 )
					Scene_Entity_Scale ( Entity (Entity_Index ) )

					Put TempBackdrop, ( 0, 0 ), .Scaled, Alpha
					Put .Scaled, ( 0, 0 ), TempBackdrop, PSet

					If TempBackdrop <> 0 Then
						TempBackdrop = ImageDestroy2 ( TempBackdrop )
					End If
		
					If .Scaled <> 0 Then
				
						x2 = x0 '- Entity ( Entity_Index ) .Scaled -> Width / 2
						y2 = cY - y0 - xA '- Entity ( Entity_Index ) .Scaled -> Height / 2

						Put Dest, ( x2, y2 ), .Scaled, Alpha
			
						ImageDestroy2 ( .Scaled )
			
					End If
			
					ImageDestroy2 ( .Sprite )
			
				End If
			
			End Select
			
		End With
		
	Next Entity_Index

End Sub
